 ; Ŀ
 ;   Mer - middle right rejustify a single text, attdef, or attribute.     
 ;   Mel - middle left rejustify a single text, attdef, or attribute.      
 ;   Mc - centre rejustify a single text, attdef, or attribute.            
 ;   Mem - middle rejustify a single text, attdef, or attribute.           
 ;   Copyright 1992 - 2010 by Rocket Software Ltd.                         
 ;                                                                         
 ; 

 ; Ŀ
 ;   Mark - mark a point.                                                  
 ;   Arguments: Pa - the point to mark.                                    
 ;              Rad - the marker segment length.                           
 ;              Colo - the marker grdraw line colour.                      
 ; 
 (DEFUN MARK (pa rad colo /)
  (grdraw (polar pa (/ pi 4) rad) (polar pa (* 1.25 pi) rad) colo)
  (grdraw (polar pa (* pi 0.75) rad) (polar pa (* pi 1.75) rad) colo)
 (princ))
 ; Ŀ
 ;   Mark end.                                                             
 ; 

 ; Ŀ
 ;   Merr - rejustify a single entity.                                     
 ;   Arguments: Enam, an entity name.                                      
 ;              Xjust, the new horizontal justification code.              
 ;   Calls nothing, Returns nothing.                                       
 ; 
 (DEFUN MERR (enam xjust / entt ten typ new10 dist angl new11 nu11)
  (setq entt (entget enam))
  (setq ten (cdr (assoc 10 entt)))                   ; starting 10 pos
  (setq typ (cdr (assoc 0 entt)))
  (if (= typ "TEXT")
      (if (assoc 73 entt)
          (setq entt (subst (cons 73 2) (assoc 73 entt) entt))
          (setq entt (append entt (list (cons 73 2)))))
      (if (assoc 74 entt)
          (setq entt (subst (cons 74 2) (assoc 74 entt) entt))
          (setq entt (append entt (list (cons 74 2))))))
  (setq entt (subst (cons 72 xjust) (assoc 72 entt) entt))   ; horiz rejustify
  (entmod entt)
  (setq entt (entget enam))                        ; get the changed ent. data
  (setq new10 (cdr (assoc 10 entt)))               ; new 10 point
  (setq dist (distance ten new10))                 ; distance moved
  (setq angl (angle new10 ten))                    ; and angle
  (setq new11 (cdr (assoc 11 entt)))               ; new insertion point
  (setq nu11 (polar new11 angl dist))              ; move ins same as 10 was
  (entmod (subst (cons 11 nu11) (assoc 11 entt) entt))
 ; Ŀ
 ;   Call mark to mark the new insertion point.                            
 ; 
  (mark nu11 (/ (getvar "viewsize") 90) 7)
 (princ))
 ; Ŀ
 ;   Merr end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Mer.                                                       
 ; 
 (DEFUN MER (xjust / *error* enam typ renam outer)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk)
   (setvar "snapmode" snapp)
   (command "undo" "end")
   (if shk (write-line shk))
  (princ))
 ; Ŀ
 ;   Get a text-like thing.                                                
 ; 
  (setq enam (car (setq nent (nentsel "Text or Attribute to Rejustify:"))))
  (setq typ (cdr (assoc 0 (setq entt (entget enam)))))
  (if (or (= "TEXT" typ) (= "ATTDEF" typ) (= "ATTRIB" typ))
      (progn
           (setq renam (cdr (assoc -1 entt)))
           (setq outer (car (reverse (car (reverse nent)))))
           (merr enam xjust)
 ; Ŀ
 ;   Update and grip the entity or its parent entity.                      
 ; 
           (entupd enam)
           (cond ((= (type outer) 'ENAME)
                  (entupd outer)
                  (sssetfirst nil (ssadd outer)))
                 ((= typ "ATTRIB")
                  (while (/= "SEQEND" (cdr (assoc 0 (entget (setq enam
                                                         (entnext enam)))))))
                  (setq enam (cdr (assoc -2 (entget enam))))
                  (sssetfirst nil (ssadd enam)))
                 (t
                  (sssetfirst nil (ssadd enam))))))
 ; Ŀ
 ;   Clean up and end.                                                     
 ;   Can't use *error* because it calls a command, cancelling the grips.   
 ; 
   (setvar "snapmode" snapp)
 (princ))
 ; Ŀ
 ;   Subroutine Mer end.                                                   
 ; 

 ; Ŀ
 ;   Mec.                                                                  
 ; 
 (DEFUN C:MEC ()
  (mer 1)
 (princ))

 ; Ŀ
 ;   Mel.                                                                  
 ; 
 (DEFUN C:MEL ()
  (mer 0)
 (princ))

 ; Ŀ
 ;   Mem.                                                                  
 ; 
 (DEFUN C:MEM ()
  (mer 0)
 (princ))

 ; Ŀ
 ;   Mer.                                                                  
 ; 
 (DEFUN C:MER ()
  (mer 2)
 (princ))
